@extends('layouts.master')
@section('title',__('All Users'))
@section('breadcum')
<div class="breadcrumbbar">
    <h4 class="page-title">{{ __('USERS') }}</h4>
    <div class="breadcrumb-list">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('Users') }}</li>
        </ol>
    </div>
</div>
@endsection
@section('maincontent')
<div class="contentbar"> 
    <div class="row">
        <div class="col-md-12">
            <div class="card m-b-50">
                <div class="card-header">
                    <button type="button" class="float-right btn btn-danger-rgba mr-2 " data-toggle="modal" data-target="#bulk_delete" title="{{ __('Delete Selected') }}"><i class="feather icon-trash mr-2"></i> {{ __('Delete Selected') }} </button>
                    <a href="{{route('users.create')}}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Add User') }}"><i class="feather icon-plus mr-2"></i>{{ __('Add User') }} </a>
                    <h5 class="card-title">{{ __('All Users') }}</h5>                    
                </div> 
                <div class="card-body device-history-page">
                    <div class="table-responsive">
                        <table id="TABLE-USER" class="table table-borderd">
    <thead>
        <tr>
            <th><input type="checkbox" id="select-all"></th>
            <th>{{ __('#') }}</th>
            <th>{{ __('USER DETAILS') }}</th>
            <th>{{ __('PROFILE PIC') }}</th>
            <th>{{ __('STATUS') }}</th>
            <th>{{ __('ACTION') }}</th>
        </tr>
    </thead>
    <tbody>
        <!-- Data will be populated by DataTable AJAX -->
    </tbody>
</table>                 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script>
$(function () {
    jQuery.noConflict();
    var table;
    
    if($.fn.dataTable.isDataTable('#TABLE-USER')){
        table = $('#TABLE-USER').DataTable();
    } else {
        table = $('#TABLE-USER').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            autoWidth: false,
            scrollCollapse: true,
            ajax: {
                url: "{{ route('users.index') }}",
                type: "GET"
            },
            columns: [
                {data: 'checkbox', name: 'checkbox', orderable: false, searchable: false},
                {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false},
                {data: 'name', name: 'name'},
                {data: 'image', name: 'image', orderable: false, searchable: false},
                {data: 'status', name: 'status', orderable: false},
                {data: 'action', name: 'action', searchable: false, orderable: false}
            ],
            dom: 'lBfrtip',
            buttons: [
                'csv', 'excel', 'pdf', 'print'
            ],
            order: [[1, 'desc']],
            "oLanguage": {
                "sEmptyTable": "<b>Let's start :)</b><br><small>Get Started by creating a user! All of your users will be displayed on this page.</small><br/>"
            }
        });
    }
    
    console.log("Table is ", table);
});

var SITEURL = '{{URL::to('')}}';

// Status button click handler
$('body').on('click', '.status', function () {
    var pid = $(this).data('id');
    var button = $(this);
    
    $.ajax({
        type: "GET",
        url: SITEURL + "/admin/user/status/" + pid,
        success: function (data) {
            if(data.success) {
                // Update button text and class
                if(data.status === 'Active') {
                    button.removeClass('btn-danger-rgba').addClass('btn-success-rgba').text('Active');
                } else {
                    button.removeClass('btn-success-rgba').addClass('btn-danger-rgba').text('Blocked');
                }
                
                // Refresh the DataTable
                $('#TABLE-USER').DataTable().ajax.reload(null, false);
            }
        },
        error: function (data) {
            console.log('Error:', data);
        }
    });
});

// Bulk delete functionality
$('#bulk_delete_form').on('submit', function(e) {
    e.preventDefault();
    
    var checkedItems = [];
    $('.user-checkbox:checked').each(function() {
        checkedItems.push($(this).val());
    });
    
    if(checkedItems.length === 0) {
        alert('Please select at least one user to delete.');
        return false;
    }
    
    // Add checked items to form
    checkedItems.forEach(function(item) {
        $('<input>').attr({
            type: 'hidden',
            name: 'checked[]',
            value: item
        }).appendTo('#bulk_delete_form');
    });
    
    // Submit the form
    this.submit();
});

// Select all checkbox functionality
$('#select-all').on('change', function() {
    $('.user-checkbox').prop('checked', $(this).is(':checked'));
});

// Individual checkbox change handler
$('body').on('change', '.user-checkbox', function() {
    var totalCheckboxes = $('.user-checkbox').length;
    var checkedCheckboxes = $('.user-checkbox:checked').length;
    
    $('#select-all').prop('checked', totalCheckboxes === checkedCheckboxes);
});

// Delete user function
function deleteUser(userId) {
    if(confirm('Are you sure you want to delete this user?')) {
        $.ajax({
            url: SITEURL + '/admin/users/' + userId,
            type: 'DELETE',
            data: {
                "_token": "{{ csrf_token() }}"
            },
            success: function(result) {
                $('#TABLE-USER').DataTable().ajax.reload();
                alert('User deleted successfully');
            },
            error: function(xhr) {
                alert('Error deleting user');
            }
        });
    }
}
</script>
@endsection